#!/usr/bin/env node
/**
 * Signal the Electron app to close a child terminal.
 * Usage: node kill_subagent.js <master_id> <child_id> [reason]
 */

const net = require('net');
const { ensureInstallEnv } = require('../install-root');

const HOST = '127.0.0.1';
const PORT = parseInt(process.env.SUBAGENT_PORT || '32123', 10);
ensureInstallEnv();

function main() {
  const [masterId, childId, ...rest] = process.argv.slice(2);
  if (!masterId || !childId) {
    console.error('Usage: node kill_subagent.js <master_id> <child_id> [reason]');
    process.exit(1);
  }

  const reason = rest.join(' ').trim();
  const payload = JSON.stringify({
    kind: 'kill',
    master_agent_id: masterId,
    child_id: childId,
    reason,
  }) + '\n';

  const socket = net.createConnection({ host: HOST, port: PORT }, () => {
    socket.write(payload);
    socket.end();
  });

  socket.on('error', (err) => {
    console.error(`Failed to send kill signal: ${err.message}`);
    process.exit(1);
  });
}

main();
